package com.vmware.samples.viewspropertiesui.views {

import com.vmware.core.model.IResourceReference;
import com.vmware.core.model.ObjectDataObject;

import com.vmware.data.Constraint;
import com.vmware.data.query.DataUpdateSpec;
import com.vmware.data.query.events.DataRequestInfo;
import com.vmware.data.query.events.DataByConstraintRequest;

import com.vmware.samples.viewspropertiesui.QuerySpecUtil;
import com.vmware.samples.viewspropertiesui.model.DatastoreDataItem;

import com.vmware.ui.IContextObjectHolder;

import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.MouseEvent;

import mx.collections.ArrayCollection;
import mx.controls.Alert;
import mx.logging.Log;
import mx.logging.ILogger;

// Declares the DataService events sent by this class.
[Event(name="{com.vmware.data.query.events.DataByConstraintRequest.REQUEST_ID}",
      type="com.vmware.data.query.events.DataByConstraintRequest")]
/**
 * The mediator for the HostSampleSummarySectionView.
 */
public class HostSampleSummarySectionViewMediator extends EventDispatcher
       implements IContextObjectHolder {

   private var _contextObject:IResourceReference;
   private var _view:HostSampleSummarySectionView;

   private static var _logger:ILogger = Log.getLogger("HostSampleSummarySectionViewMediator");

   [View]
   /**
    * The mediator's view
    */
   public function get view():HostSampleSummarySectionView {
      return _view;
   }

   /** @private */
   public function set view(value:HostSampleSummarySectionView):void {
     _view = value;
   }

   [Bindable]
   /** Returns the selected host for this view */
   public function get contextObject():Object {
      return _contextObject;
   }

   public function set contextObject(value:Object):void {
      _contextObject = IResourceReference(value);

      if (_contextObject == null) {
         clearData();
         return;
      }
      requestData();
   }

   /** Send a query to the server to load the datastore data */
   private function requestData():void {
      // Use the data request option for implicit updates of the view,
      // i.e. when the object changes for instance.
      var requestInfo:DataRequestInfo =
         new DataRequestInfo(DataUpdateSpec.newImplicitInstance());

      // First create a constraint to find all datastores for this host
      var constraint:Constraint = QuerySpecUtil.createConstraintForRelationship(
            _contextObject, "datastore");

      // Then create a DataByConstraintRequest to get the datastore properties defined
      // in the DatastoreDataItem model, their name and file system type.
      var request:DataByConstraintRequest = DataByConstraintRequest.newInstance(
            constraint, DatastoreDataItem, requestInfo);
      dispatchEvent(request);
   }

   /**
    * Handle the response to DataByConstraintRequest above. The method
    * name is not important, only its signature and the ResponseHandler tag are.
    **/
   [ResponseHandler(name="{com.vmware.data.query.events.DataByConstraintRequest.RESPONSE_ID}")]
   public function onDataRetrieved(request:DataByConstraintRequest,
            result:ArrayCollection, error:Error):void {

      if (error != null) {
         _logger.debug("onDataRetrieved error: " + error.message);
         return;
      }

      // Assigning the result to datastoreItems will update the view.
      _view.datastoreItems = result;
   }

   /** Resets the UI */
   private function clearData() : void {
      _view.datastoreItems = null;
   }
} // end class
} // end package
